/// <reference path="./internal_*.d.ts" />
declare namespace io.github.fabricators_of_create.porting_lib.util {
    class RegistryObject <T> implements Internal.Supplier<T> {
        constructor(id: ResourceLocation_, key: Internal.ResourceKey_<any>)
        filter(predicate: Internal.Predicate_<T>): this;
        stream(): Internal.Stream<T>;
        getKey(): Internal.ResourceKey<T>;
        ifPresent(consumer: Internal.Consumer_<T>): void;
        orElseGet(other: Internal.Supplier_<T>): T;
        flatMap<U>(mapper: Internal.Function_<T, Internal.Optional<U>>): Internal.Optional<U>;
        lazyMap<U>(mapper: Internal.Function_<T, U>): Internal.Supplier<U>;
        orElse(other: T): T;
        isPresent(): boolean;
        getId(): ResourceLocation;
        map<U>(mapper: Internal.Function_<T, U>): Internal.Optional<U>;
        getHolder(): Internal.Optional<Internal.Holder<T>>;
        orElseThrow<X extends Internal.Throwable>(exceptionSupplier: Internal.Supplier_<X>): T;
        get(): T;
        get key(): Internal.ResourceKey<T>
        get present(): boolean
        get id(): ResourceLocation
        get holder(): Internal.Optional<Internal.Holder<T>>
    }
    type RegistryObject_<T> = RegistryObject<T>;
}
declare namespace Internal {
    class SuspiciousStewRecipe extends Internal.CustomRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type SuspiciousStewRecipe_ = SuspiciousStewRecipe;
    class IafRecipes$1 implements Internal.RecipeType<Internal.DragonForgeRecipe> {
        static register<T extends Internal.Recipe<any>>($$0: string): Internal.RecipeType<T>;
    }
    type IafRecipes$1_ = IafRecipes$1;
    class ObjectDescJS$Entry extends Internal.Record {
        constructor(key: string, value: Internal.TypeDescJS_, optional: boolean, wrap: boolean)
        constructor(key: string, value: Internal.TypeDescJS_, optional: boolean)
        key(): string;
        value(): Internal.TypeDescJS;
        optional(): boolean;
        wrap(): boolean;
    }
    type ObjectDescJS$Entry_ = ObjectDescJS$Entry;
    class WhistleExtenderBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static findRoot(pLevel: Internal.LevelAccessor_, pPos: BlockPos_): BlockPos;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SIZE: Internal.EnumProperty<Internal.WhistleBlock$WhistleSize>;
        static readonly SHAPE: Internal.EnumProperty<Internal.WhistleExtenderBlock$WhistleExtenderShape>;
    }
    type WhistleExtenderBlock_ = WhistleExtenderBlock;
    class PointedDripstoneConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: number, $$1: number, $$2: number, $$3: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly chanceOfTallerDripstone: number;
        static readonly CODEC: Internal.Codec<Internal.PointedDripstoneConfiguration>;
        readonly chanceOfSpreadRadius2: number;
        readonly chanceOfSpreadRadius3: number;
        readonly chanceOfDirectionalSpread: number;
    }
    type PointedDripstoneConfiguration_ = PointedDripstoneConfiguration;
    interface ICraftingSubmitResult {
        abstract errorDetail(): any;
        abstract link(): Internal.ICraftingLink;
        abstract errorCode(): Internal.CraftingSubmitErrorCode;
        successful(): boolean;
    }
    type ICraftingSubmitResult_ = ICraftingSubmitResult;
    interface DragonSteelOverrides <T extends Internal.TieredItem> {
        isDragonSteelIce(tier: Internal.Tier_): boolean;
        isDragonSteelLightning(tier: Internal.Tier_): boolean;
        isDragonSteelFire(tier: Internal.Tier_): boolean;
        getAttackDamage(item: T): number;
        isDragonSteel(tier: Internal.Tier_): boolean;
        /**
         * @deprecated
        */
        abstract bakeDragonsteel(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        hurtEnemy(item: T, stack: Internal.ItemStack_, target: Internal.LivingEntity_, attacker: Internal.LivingEntity_): void;
        appendHoverText(tier: Internal.Tier_, stack: Internal.ItemStack_, worldIn: Internal.Level_, tooltip: Internal.List_<net.minecraft.network.chat.Component>, flagIn: Internal.TooltipFlag_): void;
        (): Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>;
    }
    type DragonSteelOverrides_<T extends Internal.TieredItem> = DragonSteelOverrides<T>;
    interface SingletonGeoAnimatable extends Internal.GeoAnimatable {
        registerSyncedAnimatable(animatable: Internal.GeoAnimatable_): void;
        abstract getRenderProvider(): Internal.Supplier<any>;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        stopTriggeredArmorAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        getBoneResetTime(): number;
        triggerArmorAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        abstract createRenderer(arg0: Internal.Consumer_<any>): void;
        abstract getTick(arg0: any): number;
        abstract getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        syncAnimData<D>(instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>, data: D, entityToTrack: Internal.Entity_): void;
        getAnimData<D>(instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>): D;
        triggerAnim<D>(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        setAnimData<D>(relatedEntity: Internal.Entity_, instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>, data: D): void;
        stopTriggeredAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        abstract registerControllers(arg0: Internal.AnimatableManager$ControllerRegistrar_): void;
        shouldPlayAnimsWhileGamePaused(): boolean;
        triggerAnim(instanceId: number, controllerName: string, animName: string, packetCallback: Internal.GeckoLibNetwork$IPacketCallback_): void;
        get renderProvider(): Internal.Supplier<any>
        get boneResetTime(): number
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
    }
    type SingletonGeoAnimatable_ = SingletonGeoAnimatable;
    abstract class CompositeCastingRecipe extends Internal.MaterialCastingRecipe {
        constructor(type: Internal.RecipeType_<any>, id: ResourceLocation_, group: string, result: Internal.IMaterialItem_, itemCost: number)
        isSpecial(): boolean;
        getRemainingItems($$0: Internal.ICastingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        static calcCoolingTime(fluid: Internal.FluidStack_): number;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        static calcCoolingTime(temperature: number, amount: number): number;
        getMod(): string;
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type CompositeCastingRecipe_ = CompositeCastingRecipe;
    interface CreativeModeTabExt {
        abstract setPortingData(arg0: Internal.PortingLibCreativeTab$TabData_): void;
        abstract getPortingTabData(): Internal.PortingLibCreativeTab$TabData;
        set portingData(arg0: Internal.PortingLibCreativeTab$TabData_)
        get portingTabData(): Internal.PortingLibCreativeTab$TabData
    }
    type CreativeModeTabExt_ = CreativeModeTabExt;
    class LayerPattern {
        constructor(layers: Internal.List_<Internal.LayerPattern$Layer>)
        rollNext(previous: Internal.LayerPattern$Layer_, random: Internal.RandomSource_): Internal.LayerPattern$Layer;
        static builder(): Internal.LayerPattern$Builder;
        static readonly CODEC: Internal.Codec<Internal.LayerPattern>;
        readonly layers: Internal.List<Internal.LayerPattern$Layer>;
    }
    type LayerPattern_ = LayerPattern;
    class PathComputationType extends Internal.Enum<Internal.PathComputationType> {
        static values(): Internal.PathComputationType[];
        static valueOf($$0: string): Internal.PathComputationType;
        static readonly AIR: Internal.PathComputationType;
        static readonly LAND: Internal.PathComputationType;
        static readonly WATER: Internal.PathComputationType;
    }
    type PathComputationType_ = "land" | PathComputationType | "air" | "water";
    class SpatialPylonBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWERED_ON: Internal.BooleanProperty;
    }
    type SpatialPylonBlock_ = SpatialPylonBlock;
    interface Range {
        abstract next(): void;
        abstract init(arg0: number, arg1: number): void;
        abstract index(): number;
        abstract hasMore(): boolean;
        abstract value(): number;
        abstract length(): number;
    }
    type Range_ = Range;
    interface HexHolderItem extends Internal.MediaHolderItem {
        abstract hasHex(arg0: Internal.ItemStack_): boolean;
        abstract getPigment(arg0: Internal.ItemStack_): Internal.FrozenPigment;
        abstract getMedia(arg0: Internal.ItemStack_): number;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        abstract canDrawMediaFromInventory(arg0: Internal.ItemStack_): boolean;
        abstract clearHex(arg0: Internal.ItemStack_): void;
        abstract getHex(arg0: Internal.ItemStack_, arg1: Internal.ServerLevel_): Internal.List<Internal.Iota>;
        getMediaFullness(stack: Internal.ItemStack_): number;
        abstract canRecharge(arg0: Internal.ItemStack_): boolean;
        abstract canProvideMedia(arg0: Internal.ItemStack_): boolean;
        abstract setMedia(arg0: Internal.ItemStack_, arg1: number): void;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        abstract getMaxMedia(arg0: Internal.ItemStack_): number;
        abstract writeHex(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.Iota>, arg2: Internal.FrozenPigment_, arg3: number): void;
    }
    type HexHolderItem_ = HexHolderItem;
    class AbstractIllager$IllagerArmPose extends Internal.Enum<Internal.AbstractIllager$IllagerArmPose> {
        static valueOf($$0: string): Internal.AbstractIllager$IllagerArmPose;
        static values(): Internal.AbstractIllager$IllagerArmPose[];
        static readonly BOW_AND_ARROW: Internal.AbstractIllager$IllagerArmPose;
        static readonly CROSSBOW_CHARGE: Internal.AbstractIllager$IllagerArmPose;
        static readonly CROSSED: Internal.AbstractIllager$IllagerArmPose;
        static readonly CELEBRATING: Internal.AbstractIllager$IllagerArmPose;
        static readonly NEUTRAL: Internal.AbstractIllager$IllagerArmPose;
        static readonly SPELLCASTING: Internal.AbstractIllager$IllagerArmPose;
        static readonly CROSSBOW_HOLD: Internal.AbstractIllager$IllagerArmPose;
        static readonly ATTACKING: Internal.AbstractIllager$IllagerArmPose;
    }
    type AbstractIllager$IllagerArmPose_ = "crossed" | "neutral" | "celebrating" | "spellcasting" | "attacking" | "crossbow_hold" | "bow_and_arrow" | "crossbow_charge" | AbstractIllager$IllagerArmPose;
    abstract class MultithreadEventExecutorGroup extends Internal.AbstractEventExecutorGroup {
        scheduleAtFixedRate(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): Internal.ScheduledFuture<any>;
        submit(arg0: Internal.Callable_<any>): Internal.Future<any>;
        forEach(arg0: Internal.Consumer_<Internal.EventExecutor>): void;
        executorCount(): number;
        close(): void;
        submit(arg0: Internal.Runnable_): Internal.Future<any>;
        submit(arg0: Internal.Runnable_, arg1: any): Internal.Future<any>;
        spliterator(): Internal.Spliterator<Internal.EventExecutor>;
        scheduleWithFixedDelay(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): Internal.ScheduledFuture<any>;
    }
    type MultithreadEventExecutorGroup_ = MultithreadEventExecutorGroup;
    class CreativeCrateBlock extends Internal.CrateBlock implements Internal.IBE<Internal.CreativeCrateBlockEntity> {
        constructor(p_i48415_1_: Internal.BlockBehaviour$Properties_)
        getBlockEntityClass(): typeof Internal.CreativeCrateBlockEntity;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityType(): Internal.BlockEntityType<Internal.CreativeCrateBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CreativeCrateBlockEntity;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CreativeCrateBlockEntity>): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CreativeCrateBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CreativeCrateBlockEntity>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.CreativeCrateBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.CreativeCrateBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CreativeCrateBlock_ = CreativeCrateBlock;
    abstract class PartEntity <T extends Internal.Entity> extends Internal.Entity {
        constructor(parent: T)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        getParent(): T;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        get parent(): T
    }
    type PartEntity_<T extends Internal.Entity> = PartEntity<T>;
    class TagBuilder implements Internal.FabricTagBuilder {
        constructor()
        addElement($$0: ResourceLocation_): this;
        fabric_setReplace(replace: boolean): void;
        addOptionalElement($$0: ResourceLocation_): this;
        fabric_isReplaced(): boolean;
        addTag($$0: ResourceLocation_): this;
        addOptionalTag($$0: ResourceLocation_): this;
        add($$0: Internal.TagEntry_): this;
        static create(): Internal.TagBuilder;
        build(): Internal.List<Internal.TagEntry>;
        readonly entries: Internal.List<Internal.TagEntry>;
    }
    type TagBuilder_ = TagBuilder;
    class IOBlock extends Internal.BaseEntityBlock implements Internal.MultiblockPart$MultiblockGhostPart, Internal.IBE<Internal.IOBlockEntity> {
        constructor(pr: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityType(): Internal.BlockEntityType<Internal.IOBlockEntity>;
        static makeCtx(context: Internal.UseOnContext_, pos: BlockPos_): Internal.UseOnContext;
        onActivate(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, pHit: Internal.BlockHitResult_): Internal.InteractionResult;
        hasParent(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.IOBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickBlock(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        destroyParent(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, pPlayer: Internal.Player_): void;
        getParentDir(state: Internal.BlockState_): Internal.Direction;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static propsGhost(): Internal.NonNullUnaryOperator<Internal.BlockBehaviour$Properties>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.IOBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.IOBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityClass(): typeof Internal.IOBlockEntity;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static props(): Internal.NonNullUnaryOperator<Internal.BlockBehaviour$Properties>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.IOBlockEntity>;
        get blockEntityType(): Internal.BlockEntityType<Internal.IOBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.IOBlockEntity
        static readonly TYPE: Internal.EnumProperty<Internal.IOBlockType>;
    }
    type IOBlock_ = IOBlock;
    interface WindowHooks {
        abstract borderlessmining_apply(): void;
        (): void;
    }
    type WindowHooks_ = WindowHooks;
    abstract class SettingEntry <T> {
        load(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_): void;
        key(): string;
        reset(): void;
        getOption(): Internal.SpruceOption;
        get(): T;
        save(): void;
        withOnSet(onSet: Internal.Consumer_<T>): this;
        set(value: T): void;
        get option(): Internal.SpruceOption
    }
    type SettingEntry_<T> = SettingEntry<T>;
    class HandLampItem extends Internal.ItemPackagedHex implements Internal.GenieLamp {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getMediaFullness(stack: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HandLampItem_ = HandLampItem;
    class StairsShape extends Internal.Enum<Internal.StairsShape> implements Internal.StringRepresentable {
        static values(): Internal.StairsShape[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.StairsShape;
        getSerializedName(): string;
        get serializedName(): string
        static readonly OUTER_LEFT: Internal.StairsShape;
        static readonly INNER_RIGHT: Internal.StairsShape;
        static readonly STRAIGHT: Internal.StairsShape;
        static readonly OUTER_RIGHT: Internal.StairsShape;
        static readonly INNER_LEFT: Internal.StairsShape;
    }
    type StairsShape_ = "inner_left" | "outer_left" | StairsShape | "outer_right" | "inner_right" | "straight";
    class RenderStateShard$TexturingStateShard extends Internal.RenderStateShard {
        constructor($$0: string, $$1: Internal.Runnable_, $$2: Internal.Runnable_)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$TexturingStateShard_ = RenderStateShard$TexturingStateShard;
    interface Vector3ic {
        abstract maxComponent(): number;
        abstract z(): number;
        abstract y(): number;
        abstract x(): number;
        abstract min(arg0: Internal.Vector3ic_, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract div(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract mul(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract sub(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3i_): Internal.Vector3i;
        abstract negate(arg0: Internal.Vector3i_): Internal.Vector3i;
        abstract add(arg0: Internal.Vector3ic_, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract get(arg0: Internal.IntBuffer_): Internal.IntBuffer;
        abstract add(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3i_): Internal.Vector3i;
        abstract mul(arg0: Internal.Vector3ic_, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract distanceSquared(arg0: Internal.Vector3ic_): number;
        abstract get(arg0: number, arg1: Internal.IntBuffer_): Internal.IntBuffer;
        abstract absolute(arg0: Internal.Vector3i_): Internal.Vector3i;
        abstract max(arg0: Internal.Vector3ic_, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract distance(arg0: number, arg1: number, arg2: number): number;
        abstract div(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract distanceSquared(arg0: number, arg1: number, arg2: number): number;
        abstract gridDistance(arg0: Internal.Vector3ic_): number;
        abstract sub(arg0: Internal.Vector3ic_, arg1: Internal.Vector3i_): Internal.Vector3i;
        abstract getToAddress(arg0: number): this;
        abstract lengthSquared(): number;
        abstract equals(arg0: number, arg1: number, arg2: number): boolean;
        abstract distance(arg0: Internal.Vector3ic_): number;
        abstract length(): number;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: number): number;
        abstract mul(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3i_): Internal.Vector3i;
        abstract gridDistance(arg0: number, arg1: number, arg2: number): number;
        abstract minComponent(): number;
    }
    type Vector3ic_ = Vector3ic;
    interface ArmorMaterial {
        abstract getDefenseForType(arg0: Internal.ArmorItem$Type_): number;
        abstract getDurabilityForType(arg0: Internal.ArmorItem$Type_): number;
        abstract getRepairIngredient(): Internal.Ingredient;
        abstract getName(): string;
        abstract getKnockbackResistance(): number;
        abstract getEnchantmentValue(): number;
        abstract getToughness(): number;
        abstract getEquipSound(): Internal.SoundEvent;
        get repairIngredient(): Internal.Ingredient
        get name(): string
        get knockbackResistance(): number
        get enchantmentValue(): number
        get toughness(): number
        get equipSound(): Internal.SoundEvent
    }
    type ArmorMaterial_ = string | ArmorMaterial;
    interface IConfigInvHost {
        abstract getConfig(): Internal.GenericStackInv;
        get config(): Internal.GenericStackInv
        (): Internal.GenericStackInv_;
    }
    type IConfigInvHost_ = IConfigInvHost;
    class Minecraft extends Internal.ReentrantBlockableEventLoop<Internal.Runnable> implements Internal.WindowEventHandler, Internal.MinecraftAccessor, Internal.MinecraftClientMinterface, Internal.MinecraftClientKJS, Internal.MixinClientAccessor, me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor, Internal.MinecraftExtension, Internal.MinecraftClientAccessor, Internal.AccessorMinecraft, me.lucko.spark.fabric.mixin.MinecraftClientAccessor {
        constructor($$0: Internal.GameConfig_)
        getReportingContext(): Internal.ReportingContext;
        redirect$dam000$glitchcore$startUseItem_getItemInHand(instance: Internal.LocalPlayer_, hand: Internal.InteractionHand_): Internal.ItemStack;
        getThread(): Internal.Thread;
        getResourcePackDirectory(): Internal.Path;
        handler$zfl000$porting_lib_base$port_lib$registerParticleManagers(gameConfiguration: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        debugFpsMeterKeyPress($$0: number): void;
        delayCrashRaw($$0: Internal.CrashReport_): void;
        destroy(): void;
        renderOnThread(): boolean;
        showOnlyReducedInfo(): boolean;
        handler$bld000$computercraft$beforeInitialResourceReload(gameConfig: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        clearLevel($$0: Internal.Screen_): void;
        getGpuUtilization(): number;
        getCurrentServer(): Internal.ServerData;
        getProxy(): Internal.Proxy;
        getResourceManager(): Internal.ResourceManager;
        getFps(): number;
        getOverlay(): Internal.Overlay;
        shouldEntityAppearGlowing($$0: Internal.Entity_): boolean;
        getToasts(): Internal.ToastComponent;
        getSoundManager(): Internal.SoundManager;
        static useShaderTransparency(): boolean;
        getSplashManager(): Internal.SplashManager;
        handler$hco000$resourcefullib$setInitialScreen(realmsClient: Internal.RealmsClient_, reloadInstance: Internal.ReloadInstance_, quickPlayData: Internal.GameConfig$QuickPlayData_, ci: Internal.CallbackInfo_): void;
        "handler$cjb000$fabric-registry-sync-v0$disconnectAfter"(screen_1: Internal.Screen_, info: Internal.CallbackInfo_): void;
        handler$zfl000$porting_lib_base$port_lib$onHeadJoinWorld(world: Internal.ClientLevel_, ci: Internal.CallbackInfo_): void;
        scheduleInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        handler$fka000$patchouli$onLogout(screen: Internal.Screen_, info: Internal.CallbackInfo_): void;
        runCommandSilent(command: string): number;
        scheduleRepeatingInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        setConnectedToRealms($$0: boolean): void;
        quickPlayLog(): Internal.QuickPlayLog;
        getFrameTimer(): Internal.FrameTimer;
        getResourcePackRepository(): Internal.PackRepository;
        getConnection(): Internal.Connection;
        debugClientMetricsStart($$0: Internal.Consumer_<net.minecraft.network.chat.Component>): boolean;
        getBlockEntityRenderDispatcher(): Internal.BlockEntityRenderDispatcher;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Internal.Either<Source, Internal.Exception>>, Internal.Runnable>): Internal.CompletableFuture<Source>;
        getLevelSource(): Internal.LevelStorageSource;
        getMainRenderTarget(): Internal.RenderTarget;
        getBlockRenderer(): Internal.BlockRenderDispatcher;
        handler$zfl000$porting_lib_base$port_lib$mcTail(gameConfiguration: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        setTitle(t: string): void;
        grabPanoramixScreenshot($$0: Internal.File_, $$1: number, $$2: number): net.minecraft.network.chat.Component;
        getFrameTimeNs(): number;
        getSkinManager(): Internal.SkinManager;
        allowsRealms(): boolean;
        getGpuWarnlistManager(): Internal.GpuWarnlistManager;
        getVersionType(): string;
        forceSetScreen($$0: Internal.Screen_): void;
        is64Bit(): boolean;
        populateSearchTree<T>($$0: Internal.SearchRegistry$Key_<T>, $$1: Internal.List_<T>): void;
        getTextureManager(): Internal.TextureManager;
        getRealms32BitWarningStatus(): Internal.Realms32BitWarningStatus;
        getDisplayName(): net.minecraft.network.chat.Component;
        isSingleplayer(): boolean;
        getHotbarManager(): Internal.HotbarManager;
        handler$zhc001$porting_lib_config$port_lib$modsLoaded(gameConfig: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        run(): void;
        static fillReport($$0: Internal.Minecraft_, $$1: Internal.LanguageManager_, $$2: string, $$3: Internal.Options_, $$4: Internal.CrashReport_): void;
        resizeDisplay(): void;
        setOverlay($$0: Internal.Overlay_): void;
        static useAmbientOcclusion(): boolean;
        isAltDown(): boolean;
        handler$zfl000$porting_lib_base$port_lib$onDisconnect(screen: Internal.Screen_, ci: Internal.CallbackInfo_): void;
        isLocalServer(): boolean;
        hasSingleplayerServer(): boolean;
        getTutorial(): Internal.Tutorial;
        getEntityModels(): Internal.EntityModelSet;
        getDeltaFrameTime(): number;
        handler$dam000$glitchcore$onStartUseItem(ci: Internal.CallbackInfo_): void;
        localvar$zpk000$architectury$modifyScreen(screen: Internal.Screen_): Internal.Screen;
        clearLevel(): void;
        handler$dam000$glitchcore$onBeginTick(ci: Internal.CallbackInfo_): void;
        getSearchTree<T>($$0: Internal.SearchRegistry$Key_<T>): Internal.SearchTree<T>;
        handler$zpk000$architectury$cancelSetScreen(screen: Internal.Screen_, ci: Internal.CallbackInfo_): void;
        setLastInputType($$0: Internal.InputType_): void;
        addCustomNbtData($$0: Internal.ItemStack_, $$1: Internal.BlockEntity_): void;
        setWindowActive($$0: boolean): void;
        clearResourcePacksOnError($$0: Internal.Throwable_, $$1: net.minecraft.network.chat.Component_): void;
        handler$zln000$ae2$pickColor(ci: Internal.CallbackInfo_): void;
        static useFancyGraphics(): boolean;
        handler$bfa000$balm$onSetLevel(clientLevel: Internal.ClientLevel_, ci: Internal.CallbackInfo_): void;
        getMusicManager(): Internal.MusicManager;
        delayTextureReload(): Internal.CompletableFuture<void>;
        getTextureAtlas($$0: ResourceLocation_): Internal.Function<ResourceLocation, Internal.TextureAtlasSprite>;
        getScheduledEvents(): Internal.ScheduledEvents;
        doWorldLoad($$0: string, $$1: Internal.LevelStorageSource$LevelStorageAccess_, $$2: Internal.PackRepository_, $$3: Internal.WorldStem_, $$4: boolean): void;
        static crash($$0: Internal.CrashReport_): void;
        getMobEffectTextures(): Internal.MobEffectTextureManager;
        getMinecraftSessionService(): Internal.MinecraftSessionService;
        port_lib$getGameConfig(): Internal.GameConfig;
        getLastInputType(): Internal.InputType;
        allowsTelemetry(): boolean;
        getFrameTime(): number;
        multiplayerBan(): Internal.BanDetails;
        handler$zli000$ae2$customBreakEffect(bl: boolean, ci: Internal.CallbackInfo_, blockHitResult: Internal.BlockHitResult_): void;
        "handler$ceh000$fabric-events-interaction-v0$cancelItemPick"(info: Internal.CallbackInfo_): void;
        extraTelemetryAvailable(): boolean;
        handler$zfl000$porting_lib_base$port_lib$modsLoaded(gameConfig: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        getPaintingTextures(): Internal.PaintingTextureManager;
        reloadResourcePacks(): Internal.CompletableFuture<void>;
        getDownloadedPackSource(): Internal.DownloadedPackSource;
        realmsDataFetcher(): Internal.RealmsDataFetcher;
        getLanguageManager(): Internal.LanguageManager;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Source>, Internal.Runnable>): Internal.CompletableFuture<Source>;
        setCurrentScreen(gui: Internal.Screen_): void;
        static "getCurrentFPS$sodium-extra_$md$fca01f$8"(): number;
        handler$bfa000$balm$clearLevel(p_91321_: Internal.Screen_, ci: Internal.CallbackInfo_): void;
        getWindow(): com.mojang.blaze3d.platform.Window;
        allowsMultiplayer(): boolean;
        getNarrator(): Internal.GameNarrator;
        getCurrentWorldName(): string;
        isCtrlDown(): boolean;
        prepareForMultiplayer(): void;
        schedule(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        setCameraEntity($$0: Internal.Entity_): void;
        port_lib$pausePartialTick(): number;
        getChatStatus(): Internal.Minecraft$ChatStatus;
        getProfileProperties(): Internal.PropertyMap;
        handler$hjl000$transition$fillReport(theCrash: Internal.CrashReport_, ci: Internal.CallbackInfoReturnable_<any>): void;
        pauseGame($$0: boolean): void;
        getEntityRenderDispatcher(): Internal.EntityRenderDispatcher;
        isEnforceUnicode(): boolean;
        telemetryOptInExtra(): boolean;
        setLevel($$0: Internal.ClientLevel_): void;
        updateTitle(): void;
        getVanillaPackResources(): Internal.VanillaPackResources;
        isRunning(): boolean;
        isShiftDown(): boolean;
        getName(): net.minecraft.network.chat.Component;
        static getCurrentFPS(): number;
        getSituationalMusic(): Internal.Music;
        handler$djm000$iris$trackLastDimensionOnLeave(arg: Internal.Screen_, ci: Internal.CallbackInfo_): void;
        handler$dfh000$iceberg$runTick(tickWorld: boolean, callbackInfo: Internal.CallbackInfo_): void;
        getProgressListener(): Internal.StoringChunkProgressListener;
        tick(): void;
        updateMaxMipLevel($$0: number): void;
        handler$bfa000$balm$startUseItem(callbackInfo: Internal.CallbackInfo_, hands: Internal.InteractionHand_[], var2: number, var3: number, hand: Internal.InteractionHand_): void;
        delayCrash($$0: Internal.CrashReport_): void;
        isTextFilteringEnabled(): boolean;
        stop(): void;
        handler$ddo005$hexical$tick(info: Internal.CallbackInfo_): void;
        getTelemetryManager(): Internal.ClientTelemetryManager;
        isPaused(): boolean;
        getItemRenderer(): Internal.ItemRenderer;
        getUser(): Internal.User;
        static getInstance(): Internal.Minecraft;
        getChatListener(): Internal.ChatListener;
        self(): this;
        leftClick(): void;
        getAuthenticationService(): Internal.YggdrasilAuthenticationService;
        getSingleplayerServer(): Internal.IntegratedServer;
        getProfiler(): Internal.ProfilerFiller;
        static checkModStatus(): Internal.ModCheck;
        scheduleRepeating(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        isConnectedToRealms(): boolean;
        fillReport($$0: Internal.CrashReport_): Internal.CrashReport;
        getProfileKeyPairManager(): Internal.ProfileKeyPairManager;
        static of<Msg>($$0: string, $$1: Internal.Consumer_<Msg>): Internal.ProcessorHandle<Msg>;
        isKeyDown(key: number): boolean;
        isDemo(): boolean;
        emergencySave(): void;
        setScreen($$0: Internal.Screen_): void;
        getPlayerSocialManager(): Internal.PlayerSocialManager;
        isBlocked($$0: Internal.UUID_): boolean;
        getModelManager(): Internal.ModelManager;
        renderBuffers(): Internal.RenderBuffers;
        getCurrentScreen(): Internal.Screen;
        tell(message: net.minecraft.network.chat.Component_): void;
        bookshelf$getFontManager(): Internal.FontManager;
        getProfileKeySignatureValidator(): Internal.SignatureValidator;
        getConnection(): Internal.ClientPacketListener;
        shouldShowBanNotice(): boolean;
        localvar$bfa001$balm$modifyScreen(screen: Internal.Screen_): Internal.Screen;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        updateReportEnvironment($$0: Internal.ReportEnvironment_): void;
        "localvar$ceh000$fabric-events-interaction-v0$modifyItemPick"(stack: Internal.ItemStack_): Internal.ItemStack;
        isWindowActive(): boolean;
        static renderNames(): boolean;
        getFixerUpper(): Internal.DataFixer;
        getLaunchedVersion(): string;
        rightClick(): void;
        handler$dam001$glitchcore$onEndTick(ci: Internal.CallbackInfo_): void;
        cursorEntered(): void;
        createWorldOpenFlows(): Internal.WorldOpenFlows;
        runCommand(command: string): number;
        getCameraEntity(): Internal.Entity;
        getBlockColors(): Internal.BlockColors;
        get reportingContext(): Internal.ReportingContext
        get thread(): Internal.Thread
        get resourcePackDirectory(): Internal.Path
        get gpuUtilization(): number
        get currentServer(): Internal.ServerData
        get proxy(): Internal.Proxy
        get resourceManager(): Internal.ResourceManager
        get fps(): number
        get overlay(): Internal.Overlay
        get toasts(): Internal.ToastComponent
        get soundManager(): Internal.SoundManager
        get splashManager(): Internal.SplashManager
        set connectedToRealms($$0: boolean)
        get frameTimer(): Internal.FrameTimer
        get resourcePackRepository(): Internal.PackRepository
        get connection(): Internal.Connection
        get blockEntityRenderDispatcher(): Internal.BlockEntityRenderDispatcher
        get levelSource(): Internal.LevelStorageSource
        get mainRenderTarget(): Internal.RenderTarget
        get blockRenderer(): Internal.BlockRenderDispatcher
        set title(t: string)
        get frameTimeNs(): number
        get skinManager(): Internal.SkinManager
        get gpuWarnlistManager(): Internal.GpuWarnlistManager
        get versionType(): string
        get textureManager(): Internal.TextureManager
        get realms32BitWarningStatus(): Internal.Realms32BitWarningStatus
        get displayName(): net.minecraft.network.chat.Component
        get singleplayer(): boolean
        get hotbarManager(): Internal.HotbarManager
        set overlay($$0: Internal.Overlay_)
        get altDown(): boolean
        get localServer(): boolean
        get tutorial(): Internal.Tutorial
        get entityModels(): Internal.EntityModelSet
        get deltaFrameTime(): number
        set lastInputType($$0: Internal.InputType_)
        set windowActive($$0: boolean)
        get musicManager(): Internal.MusicManager
        get scheduledEvents(): Internal.ScheduledEvents
        get mobEffectTextures(): Internal.MobEffectTextureManager
        get minecraftSessionService(): Internal.MinecraftSessionService
        get lastInputType(): Internal.InputType
        get frameTime(): number
        get paintingTextures(): Internal.PaintingTextureManager
        get downloadedPackSource(): Internal.DownloadedPackSource
        get languageManager(): Internal.LanguageManager
        set currentScreen(gui: Internal.Screen_)
        get "currentFPS$sodium-extra_$md$fca01f$8"(): number
        get window(): com.mojang.blaze3d.platform.Window
        get narrator(): Internal.GameNarrator
        get currentWorldName(): string
        get ctrlDown(): boolean
        set cameraEntity($$0: Internal.Entity_)
        get chatStatus(): Internal.Minecraft$ChatStatus
        get profileProperties(): Internal.PropertyMap
        get entityRenderDispatcher(): Internal.EntityRenderDispatcher
        get enforceUnicode(): boolean
        set level($$0: Internal.ClientLevel_)
        get vanillaPackResources(): Internal.VanillaPackResources
        get running(): boolean
        get shiftDown(): boolean
        get name(): net.minecraft.network.chat.Component
        get currentFPS(): number
        get situationalMusic(): Internal.Music
        get progressListener(): Internal.StoringChunkProgressListener
        get textFilteringEnabled(): boolean
        get telemetryManager(): Internal.ClientTelemetryManager
        get paused(): boolean
        get itemRenderer(): Internal.ItemRenderer
        get user(): Internal.User
        get instance(): Internal.Minecraft
        get chatListener(): Internal.ChatListener
        get authenticationService(): Internal.YggdrasilAuthenticationService
        get singleplayerServer(): Internal.IntegratedServer
        get profiler(): Internal.ProfilerFiller
        get connectedToRealms(): boolean
        get profileKeyPairManager(): Internal.ProfileKeyPairManager
        get demo(): boolean
        set screen($$0: Internal.Screen_)
        get playerSocialManager(): Internal.PlayerSocialManager
        get modelManager(): Internal.ModelManager
        get currentScreen(): Internal.Screen
        get profileKeySignatureValidator(): Internal.SignatureValidator
        get connection(): Internal.ClientPacketListener
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get windowActive(): boolean
        get fixerUpper(): Internal.DataFixer
        get launchedVersion(): string
        get cameraEntity(): Internal.Entity
        get blockColors(): Internal.BlockColors
        level: Internal.ClientLevel;
        static readonly UNIFORM_FONT: ResourceLocation;
        readonly frameTimer: Internal.FrameTimer;
        pausePartialTick: number;
        fpsString: string;
        static readonly DEFAULT_FONT: ResourceLocation;
        readonly options: Internal.Options;
        chunkPath: boolean;
        noRender: boolean;
        readonly itemColors: Internal.ItemColors;
        static readonly RESOURCE_RELOAD_INITIAL_TASK: Internal.CompletableFuture<net.minecraft.util.Unit>;
        cameraEntity: Internal.Entity;
        readonly fontFilterFishy: net.minecraft.client.gui.Font;
        hitResult: Internal.HitResult;
        static readonly ON_OSX: false;
        readonly debugRenderer: Internal.DebugRenderer;
        readonly gameDirectory: Internal.File;
        chunkVisibility: boolean;
        readonly particleEngine: Internal.ParticleEngine;
        screen: Internal.Screen;
        gameMode: Internal.MultiPlayerGameMode;
        readonly gameRenderer: Internal.GameRenderer;
        readonly fontManager: Internal.FontManager;
        static readonly UPDATE_DRIVERS_ADVICE: "Please make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).";
        readonly mouseHandler: Internal.MouseHandler;
        smartCull: boolean;
        readonly font: net.minecraft.client.gui.Font;
        static readonly ALT_FONT: ResourceLocation;
        readonly timer: Internal.Timer;
        readonly gui: Internal.Gui;
        wireframe: boolean;
        crosshairPickEntity: Internal.Entity;
        readonly keyboardHandler: Internal.KeyboardHandler;
        missTime: number;
        readonly levelRenderer: Internal.LevelRenderer;
        player: Internal.LocalPlayer;
    }
    type Minecraft_ = Minecraft;
    class AgriFertilizerVariant extends Internal.Record {
        constructor(item: Internal.ExtraCodecs$TagOrElementLocation_, nbt: Internal.Optional_<Internal.CompoundTag>)
        constructor(item: Internal.ExtraCodecs$TagOrElementLocation_, nbt: Internal.CompoundTag_)
        nbt(): Internal.CompoundTag;
        item(): Internal.ExtraCodecs$TagOrElementLocation;
        isVariant(itemStack: Internal.ItemStack_): boolean;
        static readonly CODEC: Internal.Codec<Internal.AgriFertilizerVariant>;
    }
    type AgriFertilizerVariant_ = AgriFertilizerVariant;
    abstract class MultipartShapedBlockBuilder extends Internal.ShapedBlockBuilder {
        constructor(i: ResourceLocation_, ...suffixes: string[])
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
    }
    type MultipartShapedBlockBuilder_ = MultipartShapedBlockBuilder;
    interface LivingEntityEvents$ChangeTarget {
        abstract onChangeTarget(arg0: Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent_): void;
        (arg0: Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent): void;
    }
    type LivingEntityEvents$ChangeTarget_ = LivingEntityEvents$ChangeTarget;
    class TelemetryEventType$Builder {
        optIn(): this;
        defineAll($$0: Internal.List_<Internal.TelemetryProperty<any>>): this;
        register(): Internal.TelemetryEventType;
        define<T>($$0: Internal.TelemetryProperty_<T>): this;
    }
    type TelemetryEventType$Builder_ = TelemetryEventType$Builder;
    class Painter implements Internal.UnitVariables {
        constructor(id: string)
        inGameScreenDraw(graphics: Internal.GuiGraphics_, delta: number): void;
        unitOf(cx: Internal.Context_, o: any): Internal.Unit;
        registerBuiltinObjects(): void;
        getObject(key: string): Internal.PainterObject;
        clear(): void;
        make(type: string): Internal.PainterObject;
        getVariables(): Internal.VariableSet;
        unitOf(console: Internal.ConsoleJS_, o: any): Internal.Unit;
        paint(root: Internal.CompoundTag_): void;
        guiScreenDraw(screen: Internal.Screen_, graphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, delta: number): void;
        setVariable(key: string, variable: Internal.Unit_): void;
        get variables(): Internal.VariableSet
        readonly mouseXUnit: Internal.MutableNumberUnit;
        readonly screenHeightUnit: Internal.MutableNumberUnit;
        readonly defaultLineSizeUnit: Internal.MutableNumberUnit;
        readonly id: string;
        static readonly INSTANCE: Internal.Painter;
        readonly screenWidthUnit: Internal.MutableNumberUnit;
        readonly deltaUnit: Internal.MutableNumberUnit;
        readonly unitContext: Internal.UnitContext;
        readonly mouseYUnit: Internal.MutableNumberUnit;
    }
    type Painter_ = Painter;
    interface DimensionEffectsAccessor {
        getIdentifierMap(): Internal.Object2ObjectMap<ResourceLocation, Internal.DimensionSpecialEffects>;
        get identifierMap(): Internal.Object2ObjectMap<ResourceLocation, Internal.DimensionSpecialEffects>
    }
    type DimensionEffectsAccessor_ = DimensionEffectsAccessor;
    class GlowBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        addGlow(world: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type GlowBlock_ = GlowBlock;
    interface ICraftingSimulationRequester {
        abstract getActionSource(): Internal.IActionSource;
        getGridNode(): Internal.IGridNode;
        get actionSource(): Internal.IActionSource
        get gridNode(): Internal.IGridNode
        (): Internal.IActionSource_;
    }
    type ICraftingSimulationRequester_ = ICraftingSimulationRequester;
    class SchematicTableBlock extends Internal.HorizontalDirectionalBlock implements Internal.IBE<Internal.SchematicTableBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SchematicTableBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityClass(): typeof Internal.SchematicTableBlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SchematicTableBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SchematicTableBlockEntity>;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SchematicTableBlockEntity>): void;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SchematicTableBlockEntity;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.SchematicTableBlockEntity
        set lightEmission(v: number)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.SchematicTableBlockEntity>
        set destroySpeed(v: number)
    }
    type SchematicTableBlock_ = SchematicTableBlock;
    /**
     * Invoked before a living entity dies.
     * 
     * **NOTE**: You need to set hp to > 0 besides cancelling the event to prevent the entity from dying.
    */
    class LivingEntityDeathEventJS extends Internal.LivingEntityEventJS {
        constructor(entity: Internal.LivingEntity_, source: DamageSource_)
        /**
         * The damage source that triggers the death.
        */
        getSource(): DamageSource;
        /**
         * The damage source that triggers the death.
        */
        get source(): DamageSource
    }
    type LivingEntityDeathEventJS_ = LivingEntityDeathEventJS;
    class Climate$RTree <T> {
        search($$0: Internal.Climate$TargetPoint_, $$1: Internal.Climate$DistanceMetric_<T>): T;
        static create<T>($$0: Internal.List_<com.mojang.datafixers.util.Pair<Internal.Climate$ParameterPoint, T>>): Internal.Climate$RTree<T>;
    }
    type Climate$RTree_<T> = Climate$RTree<T>;
    class SequencedAssemblyRecipeSerializer implements Internal.RecipeSerializer<Internal.SequencedAssemblyRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.SequencedAssemblyRecipe;
        fromNetwork(id: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.SequencedAssemblyRecipe;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: Internal.SequencedAssemblyRecipe_): void;
        write(json: Internal.JsonObject_, recipe: Internal.SequencedAssemblyRecipe_): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type SequencedAssemblyRecipeSerializer_ = SequencedAssemblyRecipeSerializer;
    class BoneSpineFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type BoneSpineFeature_ = BoneSpineFeature;
    class GirderBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.SimpleWaterloggedBlock {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        static isZGirder(state: Internal.BlockState_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static isXGirder(state: Internal.BlockState_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        static isFacingBracket(level: Internal.BlockAndTintGetter_, pos: BlockPos_, d: Internal.Direction_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        static updateState(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_, d: Internal.Direction_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static updateVerticalProperty(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_, updateProperty: Internal.Property_<boolean>, sideState: Internal.BlockState_, d: Internal.Direction_): Internal.BlockState;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static isGirder(state: Internal.BlockState_): boolean;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static isConnected(world: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.BlockState_, side: Internal.Direction_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly TOP: Internal.BooleanProperty;
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
        static readonly Z: Internal.BooleanProperty;
        static readonly BOTTOM: Internal.BooleanProperty;
        static readonly X: Internal.BooleanProperty;
    }
    type GirderBlock_ = GirderBlock;
    abstract class SerializableDataTicket <D> extends Internal.DataTicket<D> {
        constructor(id: string, objectType: D)
        static ofEnum<E extends Internal.Enum<E>>(id: ResourceLocation_, enumClass: E): Internal.SerializableDataTicket<E>;
        abstract decode(arg0: Internal.FriendlyByteBuf_): D;
        abstract encode(arg0: D, arg1: Internal.FriendlyByteBuf_): void;
        static ofInt(id: ResourceLocation_): Internal.SerializableDataTicket<number>;
        static ofString(id: ResourceLocation_): Internal.SerializableDataTicket<string>;
        static ofDouble(id: ResourceLocation_): Internal.SerializableDataTicket<number>;
        static ofBoolean(id: ResourceLocation_): Internal.SerializableDataTicket<boolean>;
        static ofFloat(id: ResourceLocation_): Internal.SerializableDataTicket<number>;
    }
    type SerializableDataTicket_<D> = SerializableDataTicket<D>;
    class MainSettingsCategory <T extends Internal.MainSettingsCategory<any>> implements Internal.ISettingsCategory<T> {
        constructor(categoryNbt: Internal.CompoundTag_, saveNbt: Internal.Consumer_<Internal.CompoundTag>, playerSettingsTagName: string)
        deleteSlotSettingsFrom(slotIndex: number): void;
        getSettingValue<S>(setting: Internal.MainSetting_<S>): Internal.Optional<S>;
        isLargerThanNumberOfSlots(slots: number): boolean;
        getPlayerSettingsTagName(): string;
        copyTo(arg0: Internal.ISettingsCategory_<any>, arg1: number, arg2: number): void;
        removeSetting<S>(setting: Internal.MainSetting_<S>): void;
        reloadFrom(categoryNbt: Internal.CompoundTag_): void;
        setSettingValue<S>(setting: Internal.MainSetting_<S>, value: S): void;
        overwriteWith(otherCategory: T): void;
        copyTo(otherCategory: T, startFromSlot: number, slotOffset: number): void;
        overwriteWith(arg0: Internal.ISettingsCategory_<any>): void;
        get playerSettingsTagName(): string
        static readonly NAME: "global";
    }
    type MainSettingsCategory_<T extends Internal.MainSettingsCategory<any>> = MainSettingsCategory<T>;
    interface Object2CharFunction <K> extends it.unimi.dsi.fastutil.Function<K, string>, Internal.ToIntFunction<K> {
        put(arg0: K, arg1: string): string;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2CharFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Object2ShortFunction<K>;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        removeChar(arg0: any): string;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): string;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Object2IntFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, string>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2CharFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): string;
        containsKey(arg0: any): boolean;
        abstract getChar(arg0: any): string;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2CharFunction;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2CharFunction<T>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2CharFunction;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: string): string;
        defaultReturnValue(arg0: string): void;
        /**
         * @deprecated
        */
        get(arg0: any): string;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        apply(arg0: K): string;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Object2ByteFunction<K>;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Object2LongFunction<K>;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2CharFunction<T>;
        applyAsInt(arg0: K): number;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2CharFunction;
        size(): number;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2CharFunction;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        clear(): void;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Object2FloatFunction<K>;
        getOrDefault(arg0: any, arg1: string): string;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<K, T>;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        identity<T>(): Internal.Function<T, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2CharFunction;
        (arg0: any): string;
    }
    type Object2CharFunction_<K> = Object2CharFunction<K>;
    class ColoredPartItem <T extends Internal.IPart> extends Internal.PartItem<T> {
        constructor(properties: Internal.Item$Properties_, partClass: T, factory: Internal.Function_<Internal.ColoredPartItem<T>, T>, color: Internal.AEColor_)
        static getId(item: Internal.IPartItem_<any>): ResourceLocation;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getColor(): Internal.AEColor;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        static byId(id: ResourceLocation_): Internal.IPartItem<any>;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static byNetworkId(id: number): Internal.IPartItem<any>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static getNetworkId(item: Internal.IPartItem_<any>): number;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get color(): Internal.AEColor
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ColoredPartItem_<T extends Internal.IPart> = ColoredPartItem<T>;
    class ModOrigin$Kind extends Internal.Enum<Internal.ModOrigin$Kind> {
        static valueOf(arg0: string): Internal.ModOrigin$Kind;
        static values(): Internal.ModOrigin$Kind[];
        static readonly NESTED: Internal.ModOrigin$Kind;
        static readonly UNKNOWN: Internal.ModOrigin$Kind;
        static readonly PATH: Internal.ModOrigin$Kind;
    }
    type ModOrigin$Kind_ = "nested" | "path" | "unknown" | ModOrigin$Kind;
    class SurfaceRules$Context {
        updateY(stoneDepthAbove: number, stoneDepthBelow: number, waterHeight: number, blockX: number, blockY: number, blockZ: number): void;
        biome: Internal.Supplier<Internal.Holder<Internal.Biome>>;
        readonly biomeGetter: Internal.Function<BlockPos, Internal.Holder<Internal.Biome>>;
    }
    type SurfaceRules$Context_ = SurfaceRules$Context;
    class TrainTrapdoorBlock extends Internal.TrapDoorBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        constructor(properties: Internal.BlockBehaviour$Properties_, type: Internal.BlockSetType_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static metal(properties: Internal.BlockBehaviour$Properties_): Internal.TrainTrapdoorBlock;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        static isConnected(state: Internal.BlockState_, other: Internal.BlockState_, pDirection: Internal.Direction_): boolean;
        emi(amount: number): Internal.EmiStack;
        static glass(properties: Internal.BlockBehaviour$Properties_): Internal.TrainTrapdoorBlock;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TrainTrapdoorBlock_ = TrainTrapdoorBlock;
    abstract class ImmutableCollections$AbstractImmutableMap <K, V> extends Internal.AbstractMap<K, V> implements Internal.Serializable {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        putIfAbsent(arg0: K, arg1: V): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
    }
    type ImmutableCollections$AbstractImmutableMap_<K, V> = ImmutableCollections$AbstractImmutableMap<K, V>;
    class PalettedContainerRO$PackedData <T> extends Internal.Record {
        constructor($$0: Internal.List_<T>, $$1: Internal.Optional_<Internal.LongStream>)
        paletteEntries(): Internal.List<T>;
        storage(): Internal.Optional<Internal.LongStream>;
    }
    type PalettedContainerRO$PackedData_<T> = PalettedContainerRO$PackedData<T>;
    abstract class BaseComfortsBlock extends Internal.BedBlock implements Internal.SimpleWaterloggedBlock {
        constructor(type: any_, colorIn: Internal.DyeColor_, properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        static trySleep(player: Internal.ServerPlayer_, at: BlockPos_, dryRun: boolean): Internal.Either<Internal.Player$BedSleepingProblem, net.minecraft.util.Unit>;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        abstract getBlockEntityType(): Internal.BlockEntityType<Internal.BaseComfortsBlockEntity>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.BaseComfortsBlockEntity>
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type BaseComfortsBlock_ = BaseComfortsBlock;
    class Runtime$Version implements Internal.Comparable<Internal.Runtime$Version> {
        build(): Internal.Optional<number>;
        update(): number;
        patch(): number;
        static parse(arg0: string): Internal.Runtime$Version;
        compareTo(arg0: Internal.Runtime$Version_): number;
        compareTo(arg0: any): number;
        feature(): number;
        interim(): number;
        equalsIgnoreOptional(arg0: any): boolean;
        version(): Internal.List<number>;
        /**
         * @deprecated
        */
        minor(): number;
        compareToIgnoreOptional(arg0: Internal.Runtime$Version_): number;
        /**
         * @deprecated
        */
        major(): number;
        optional(): Internal.Optional<string>;
        /**
         * @deprecated
        */
        security(): number;
        pre(): Internal.Optional<string>;
    }
    type Runtime$Version_ = Runtime$Version;
    class Zombie extends Internal.Monster {
        constructor($$0: Internal.EntityType_<Internal.Zombie>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setCanBreakDoors($$0: boolean): void;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static getSpawnAsBabyOdds($$0: Internal.RandomSource_): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        isUnderWaterConverting(): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        canBreakDoors(): boolean;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        set canBreakDoors($$0: boolean)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        get underWaterConverting(): boolean
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly ZOMBIE_LEADER_CHANCE: 0.05;
        static readonly REINFORCEMENT_RANGE_MIN: 7;
        static readonly REINFORCEMENT_RANGE_MAX: 40;
        static readonly REINFORCEMENT_ATTEMPTS: 50;
    }
    type Zombie_ = Zombie;
    class ExperienceBlock extends Internal.Block {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ExperienceBlock_ = ExperienceBlock;
    class CreeperEffect implements Internal.PrestidigitationEffect {
        constructor()
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
    }
    type CreeperEffect_ = CreeperEffect;
    class LadderBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type LadderBlock_ = LadderBlock;
    class CogwheelBlockItem extends Internal.BlockItem implements Internal.UseFirstBehaviorItem {
        constructor(block: Internal.CogWheelBlock_, builder: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CogwheelBlockItem_ = CogwheelBlockItem;
    interface NativeWindowHandle {
        abstract getWin32Handle(): number;
        get win32Handle(): number
        (): number;
    }
    type NativeWindowHandle_ = NativeWindowHandle;
    interface PlayerComponent <C extends dev.onyxstudios.cca.api.v3.component.Component> extends dev.onyxstudios.cca.api.v3.component.Component, Internal.CopyableComponent<C> {
        abstract readFromNbt(arg0: Internal.CompoundTag_): void;
        copyForRespawn(original: C, lossless: boolean, keepInventory: boolean, sameCharacter: boolean): void;
        abstract writeToNbt(arg0: Internal.CompoundTag_): void;
        shouldCopyForRespawn(lossless: boolean, keepInventory: boolean, sameCharacter: boolean): boolean;
        abstract equals(arg0: any): boolean;
        copyFrom(other: C): void;
    }
    type PlayerComponent_<C extends dev.onyxstudios.cca.api.v3.component.Component> = PlayerComponent<C>;
    interface ConstProperties {
        abstract isConst(arg0: string): boolean;
        abstract putConst(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_, arg3: any): void;
        abstract defineConst(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_): void;
    }
    type ConstProperties_ = ConstProperties;
    class Enchantment$Rarity extends Internal.Enum<Internal.Enchantment$Rarity> {
        static values(): Internal.Enchantment$Rarity[];
        getWeight(): number;
        static valueOf($$0: string): Internal.Enchantment$Rarity;
        get weight(): number
        static readonly VERY_RARE: Internal.Enchantment$Rarity;
        static readonly RARE: Internal.Enchantment$Rarity;
        static readonly UNCOMMON: Internal.Enchantment$Rarity;
        static readonly COMMON: Internal.Enchantment$Rarity;
    }
    type Enchantment$Rarity_ = "uncommon" | "rare" | "common" | "very_rare" | Enchantment$Rarity;
    class CableBusBlock extends Internal.AEBaseEntityBlock<any> implements Internal.ICustomBlockHitEffect, Internal.IDynamicLadder, Internal.SimpleWaterloggedBlock, Internal.INeighborChangeSensitive, Internal.IAEFacade, Internal.ICustomBlockDestroyEffect, Internal.ICustomPickBlock {
        constructor()
        onNeighborChange(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_, neighbor: BlockPos_): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getFacadeState(level: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPickBlock(state: Internal.BlockState_, target: Internal.HitResult_, level: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_): Internal.ItemStack;
        setDestroySpeed(v: number): void;
        recolorBlock(level: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_, color: Internal.DyeColor_, who: Internal.Player_): boolean;
        canConnectRedstone(level: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getStateForPlacement(level: Internal.Level_, pos: BlockPos_): Internal.BlockState;
        emi(): Internal.EmiStack;
        isLadder(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_, entity: Internal.LivingEntity_): boolean;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static RENDERING_FACADE_DIRECTION: Internal.ThreadLocal<Internal.Direction>;
    }
    type CableBusBlock_ = CableBusBlock;
    class RedstoneLinkBlock extends Internal.WrenchableDirectionalBlock implements Internal.ConnectableRedstoneBlock, Internal.IBE<Internal.RedstoneLinkBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityType(): Internal.BlockEntityType<Internal.RedstoneLinkBlockEntity>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.RedstoneLinkBlockEntity>): void;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        toggleMode(state: Internal.BlockState_, worldIn: Internal.Level_, pos: BlockPos_): Internal.InteractionResult;
        getBlockEntityClass(): typeof Internal.RedstoneLinkBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.RedstoneLinkBlockEntity>;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        updateTransmittedSignal(state: Internal.BlockState_, worldIn: Internal.Level_, pos: BlockPos_): void;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.RedstoneLinkBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.RedstoneLinkBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get blockEntityType(): Internal.BlockEntityType<Internal.RedstoneLinkBlockEntity>
        get blockEntityClass(): typeof Internal.RedstoneLinkBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly RECEIVER: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type RedstoneLinkBlock_ = RedstoneLinkBlock;
    class VerticalAnchor$BelowTop extends Internal.Record implements Internal.VerticalAnchor {
        constructor($$0: number)
        static aboveBottom($$0: number): Internal.VerticalAnchor;
        static absolute($$0: number): Internal.VerticalAnchor;
        static belowTop($$0: number): Internal.VerticalAnchor;
        static bottom(): Internal.VerticalAnchor;
        static top(): Internal.VerticalAnchor;
        resolveY($$0: Internal.WorldGenerationContext_): number;
        offset(): number;
        static readonly CODEC: Internal.Codec<Internal.VerticalAnchor$BelowTop>;
    }
    type VerticalAnchor$BelowTop_ = VerticalAnchor$BelowTop;
    interface UniformHeightAccessor {
        abstract getMinInclusive(): Internal.VerticalAnchor;
        abstract getMaxInclusive(): Internal.VerticalAnchor;
        get minInclusive(): Internal.VerticalAnchor
        get maxInclusive(): Internal.VerticalAnchor
    }
    type UniformHeightAccessor_ = UniformHeightAccessor;
    class DisplayLinkBlock extends Internal.WrenchableDirectionalBlock implements Internal.IBE<Internal.DisplayLinkBlockEntity> {
        constructor(p_i48415_1_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityClass(): typeof Internal.DisplayLinkBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.DisplayLinkBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.DisplayLinkBlockEntity>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.DisplayLinkBlockEntity>;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static notifyGatherers(level: Internal.LevelAccessor_, pos: BlockPos_): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.DisplayLinkBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        static sendToGatherers<T extends Internal.DisplaySource>(level: Internal.LevelAccessor_, pos: BlockPos_, callback: Internal.BiConsumer_<Internal.DisplayLinkBlockEntity, T>, type: T): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.DisplayLinkBlockEntity>;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.DisplayLinkBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.DisplayLinkBlockEntity>
        static readonly POWERED: Internal.BooleanProperty;
    }
    type DisplayLinkBlock_ = DisplayLinkBlock;
    class Excluder implements Internal.TypeAdapterFactory, Internal.Cloneable {
        constructor()
        withVersion(arg0: number): this;
        excludeClass(arg0: typeof any, arg1: boolean): boolean;
        excludeField(arg0: Internal.Field_, arg1: boolean): boolean;
        withExclusionStrategy(arg0: Internal.ExclusionStrategy_, arg1: boolean, arg2: boolean): this;
        withModifiers(...arg0: number[]): this;
        excludeFieldsWithoutExposeAnnotation(): this;
        disableInnerClassSerialization(): this;
        create<T>(arg0: Internal.Gson_, arg1: com.google.gson.reflect.TypeToken_<T>): Internal.TypeAdapter<T>;
        static readonly DEFAULT: Internal.Excluder;
    }
    type Excluder_ = Excluder;
    interface RegionBasedStorageSectionExtended <R> {
        abstract getInChunkColumn(arg0: number, arg1: number): Internal.Iterable<R>;
        abstract getWithinChunkColumn(arg0: number, arg1: number): Internal.Stream<R>;
    }
    type RegionBasedStorageSectionExtended_<R> = RegionBasedStorageSectionExtended<R>;
    interface WalkOnSnowItem {
        canWalkOnPowderedSnow(stack: Internal.ItemStack_, wearer: Internal.LivingEntity_): boolean;
    }
    type WalkOnSnowItem_ = WalkOnSnowItem;
    class CarriageSyncData {
        constructor()
        read(buffer: Internal.FriendlyByteBuf_): void;
        write(buffer: Internal.FriendlyByteBuf_): void;
        approach(entity: Internal.CarriageContraptionEntity_, carriage: Internal.Carriage_, partialIn: number): void;
        getDistanceTo(graph: Internal.TrackGraph_, current: Internal.TravellingPoint_, target: Internal.TravellingPoint_, maxDistance: number, forward: boolean): number;
        update(entity: Internal.CarriageContraptionEntity_, carriage: Internal.Carriage_): void;
        copy(): this;
        isDirty(): boolean;
        setDirty(dirty: boolean): void;
        apply(entity: Internal.CarriageContraptionEntity_, carriage: Internal.Carriage_): void;
        get dirty(): boolean
        set dirty(dirty: boolean)
        fallbackLocations: net.createmod.catnip.data.Pair<Vec3d, Internal.Couple<Vec3d>>;
        leadingCarriage: boolean;
        distanceToDestination: number;
        wheelLocations: Internal.Vector<net.createmod.catnip.data.Pair<Internal.Couple<number>, number>>;
    }
    type CarriageSyncData_ = CarriageSyncData;
    class ModifiableArmorItem extends Internal.ArmorItem implements Internal.IModifiableDisplay, Internal.RepairableItem, Internal.CustomEnchantingBehaviorItem, Internal.WalkOnSnowItem, Internal.DamageableItem, Internal.FabricElytraItem, Internal.ToolActionItem, Internal.PiglinsNeutralItem {
        constructor(materialIn: Internal.ArmorMaterial_, slot: Internal.ArmorItem$Type_, builderIn: Internal.Item$Properties_, toolDefinition: Internal.ToolDefinition_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        constructor(material: any_, slotType: any_, properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        getMaxDamage(stack: Internal.ItemStack_): number;
        elytraFlightTick(stack: Internal.ItemStack_, entity: Internal.LivingEntity_, flightTicks: number): boolean;
        isRepairable(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getItemStackLimit(stack: Internal.ItemStack_): number;
        getToolDefinition(): Internal.ToolDefinition;
        setAttackSpeed(attackSpeed: number): void;
        canWalkOnPowderedSnow(stack: Internal.ItemStack_, wearer: Internal.LivingEntity_): boolean;
        canApplyAtEnchantingTable(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): boolean;
        doVanillaElytraTick(entity: Internal.LivingEntity_, chestStack: Internal.ItemStack_): void;
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: slimeknights.tconstruct.library.utils.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        fillItemCategory(items: Internal.FabricItemGroupEntries_): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getRenderTool(): Internal.ItemStack;
        isBookEnchantable(stack: Internal.ItemStack_, book: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        makesPiglinsNeutral(stack: Internal.ItemStack_, wearer: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPerformAction(stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): boolean;
        getDamage(stack: Internal.ItemStack_): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: Internal.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        damageItem<T extends Internal.LivingEntity>(stack: Internal.ItemStack_, amount: number, damager: T, onBroken: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getAttributeModifiers(tool: Internal.IToolStackView_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        setDamage(stack: Internal.ItemStack_, damage: number): void;
        useCustomElytra(entity: Internal.LivingEntity_, stack: Internal.ItemStack_, tickElytra: boolean): boolean;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        get toolDefinition(): Internal.ToolDefinition
        set attackSpeed(attackSpeed: number)
        get renderTool(): Internal.ItemStack
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        static readonly ELYTRA: ResourceLocation;
        static readonly PIGLIN_NEUTRAL: ResourceLocation;
        static readonly SNOW_BOOTS: ResourceLocation;
    }
    type ModifiableArmorItem_ = ModifiableArmorItem;
    class Markings extends Internal.Enum<Internal.Markings> {
        static byId($$0: number): Internal.Markings;
        static values(): Internal.Markings[];
        static valueOf($$0: string): Internal.Markings;
        getId(): number;
        get id(): number
        static readonly BLACK_DOTS: Internal.Markings;
        static readonly WHITE_FIELD: Internal.Markings;
        static readonly NONE: Internal.Markings;
        static readonly WHITE: Internal.Markings;
        static readonly WHITE_DOTS: Internal.Markings;
    }
    type Markings_ = "white_field" | "white" | "black_dots" | Markings | "white_dots" | "none";
    interface GuiGraphicsAccessor {
        abstract callRenderTooltipInternal(arg0: net.minecraft.client.gui.Font_, arg1: Internal.List_<Internal.ClientTooltipComponent>, arg2: number, arg3: number, arg4: Internal.ClientTooltipPositioner_): void;
        (arg0: net.minecraft.client.gui.Font, arg1: Internal.List<Internal.ClientTooltipComponent>, arg2: number, arg3: number, arg4: Internal.ClientTooltipPositioner): void;
    }
    type GuiGraphicsAccessor_ = GuiGraphicsAccessor;
    class NormalNoise$NoiseParameters extends Internal.Record {
        constructor($$0: number, $$1: Internal.DoubleList_)
        constructor($$0: number, $$1: number, ...$$2: number[])
        constructor($$0: number, $$1: Internal.List_<number>)
        amplitudes(): Internal.DoubleList;
        firstOctave(): number;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.NormalNoise$NoiseParameters>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.NormalNoise$NoiseParameters>>;
    }
    type NormalNoise$NoiseParameters_ = Special.Noise | NormalNoise$NoiseParameters;
    interface IContraptionFuel {
        abstract railways$getFluidFuels(): Internal.MountedFluidStorageWrapper;
        (): Internal.MountedFluidStorageWrapper_;
    }
    type IContraptionFuel_ = IContraptionFuel;
    class DiamondGritSandpaper extends Internal.SandPaperItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DiamondGritSandpaper_ = DiamondGritSandpaper;
    interface HolderGetter <T> {
        abstract get(arg0: Internal.TagKey_<T>): Internal.Optional<Internal.HolderSet$Named<T>>;
        abstract get(arg0: Internal.ResourceKey_<T>): Internal.Optional<Internal.Holder$Reference<T>>;
        getOrThrow($$0: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        getOrThrow($$0: Internal.ResourceKey_<T>): Internal.Holder$Reference<T>;
    }
    type HolderGetter_<T> = HolderGetter<T>;
    class ConsumableItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_, hasFoodEffectTooltip: boolean)
        constructor(properties: Internal.Item$Properties_)
        constructor(properties: Internal.Item$Properties_, hasFoodEffectTooltip: boolean, hasCustomTooltip: boolean)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        affectConsumer(stack: Internal.ItemStack_, level: Internal.Level_, consumer: Internal.LivingEntity_): void;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ConsumableItem_ = ConsumableItem;
    interface EmiRenderable {
        abstract render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.GuiGraphics, arg1: number, arg2: number, arg3: number): void;
    }
    type EmiRenderable_ = EmiRenderable;
    class CopycatBlockEntity extends Internal.SmartBlockEntity implements Internal.SpecialBlockEntityItemRequirement, Internal.TransformableBlockEntity, Internal.PartialSafeNBT, Internal.RenderDataBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setConsumedItem(stack: Internal.ItemStack_): void;
        hasCustomMaterial(): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setMaterial(blockState: Internal.BlockState_): void;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        cycleMaterial(): boolean;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(be: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        getMaterial(): Internal.BlockState;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getConsumedItem(): Internal.ItemStack;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        set consumedItem(stack: Internal.ItemStack_)
        set material(blockState: Internal.BlockState_)
        get infiniteBoundingBox(): Internal.AABB
        get material(): Internal.BlockState
        get consumedItem(): Internal.ItemStack
    }
    type CopycatBlockEntity_ = CopycatBlockEntity;
    class MonoTrackBufferBlock extends Internal.WoodVariantTrackBufferBlock {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.WoodVariantTrackBufferBlockEntity>): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.WoodVariantTrackBufferBlockEntity>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.WoodVariantTrackBufferBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.WoodVariantTrackBufferBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STYLE: Internal.EnumProperty<Internal.MonoTrackBufferBlock$Style>;
        static readonly UPSIDE_DOWN: Internal.BooleanProperty;
    }
    type MonoTrackBufferBlock_ = MonoTrackBufferBlock;
    abstract class AbstractEnergyBlock <C extends Internal.IEnergyConfig<owmii.powah.block.Tier>, B extends Internal.AbstractEnergyBlock<C, B>> extends Internal.AbstractBlock<owmii.powah.block.Tier, B> implements Internal.IConfigHolder<owmii.powah.block.Tier, C>, Internal.InfoBox$IInfoBoxHolder, Internal.IEnergyItemProvider {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getInfoBox(stack: Internal.ItemStack_, box: Internal.InfoBox_): Internal.InfoBox;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        isChargeable(stack: Internal.ItemStack_): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        additionalEnergyInfo(stack: Internal.ItemStack_, energy: Internal.Energy$Item_, tooltip: Internal.List_<net.minecraft.network.chat.Component>): void;
        abstract getConfig(): C;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getTransferType(): Internal.Transfer;
        addEnergyInfo(stack: Internal.ItemStack_, storage: Internal.Energy$Item_, tooltip: Internal.List_<net.minecraft.network.chat.Component>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        addEnergyTransferInfo(stack: Internal.ItemStack_, storage: Internal.Energy$Item_, tooltip: Internal.List_<net.minecraft.network.chat.Component>): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get config(): C
        get mod(): string
        set destroySpeed(v: number)
        get transferType(): Internal.Transfer
    }
    type AbstractEnergyBlock_<C extends Internal.IEnergyConfig<owmii.powah.block.Tier>, B extends Internal.AbstractEnergyBlock<C, B>> = AbstractEnergyBlock<C, B>;
    class DummySensor extends Internal.Sensor<Internal.LivingEntity> {
        constructor()
    }
    type DummySensor_ = DummySensor;
    interface BuilderAccessor {
        abstract getPools(): Internal.List<Internal.LootPool>;
        get pools(): Internal.List<Internal.LootPool>
        (): Internal.List_<Internal.LootPool>;
    }
    type BuilderAccessor_ = BuilderAccessor;
    class ServerData {
        constructor($$0: string, $$1: string, $$2: boolean)
        isLan(): boolean;
        enforcesSecureChat(): boolean;
        setResourcePackStatus($$0: Internal.ServerData$ServerPackStatus_): void;
        write(): Internal.CompoundTag;
        setIconBytes($$0: number[]): void;
        static read($$0: Internal.CompoundTag_): Internal.ServerData;
        copyNameIconFrom($$0: Internal.ServerData_): void;
        setEnforcesSecureChat($$0: boolean): void;
        getIconBytes(): number[];
        getResourcePackStatus(): Internal.ServerData$ServerPackStatus;
        copyFrom($$0: Internal.ServerData_): void;
        get lan(): boolean
        set resourcePackStatus($$0: Internal.ServerData$ServerPackStatus_)
        set iconBytes($$0: number[])
        set enforcesSecureChat($$0: boolean)
        get iconBytes(): number[]
        get resourcePackStatus(): Internal.ServerData$ServerPackStatus
        name: string;
        playerList: Internal.List<net.minecraft.network.chat.Component>;
        ip: string;
        players: Internal.ServerStatus$Players;
        ping: number;
        motd: net.minecraft.network.chat.Component;
        pinged: boolean;
        version: net.minecraft.network.chat.Component;
        status: net.minecraft.network.chat.Component;
        protocol: number;
    }
    type ServerData_ = ServerData;
    abstract class TestFluid extends Internal.StarFluid {
        constructor()
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type TestFluid_ = TestFluid;
    class FoodProperties {
        getSaturationModifier(): number;
        getEffects(): Internal.List<com.mojang.datafixers.util.Pair<Internal.MobEffectInstance, number>>;
        isMeat(): boolean;
        getNutrition(): number;
        isFastFood(): boolean;
        canAlwaysEat(): boolean;
        get saturationModifier(): number
        get effects(): Internal.List<com.mojang.datafixers.util.Pair<Internal.MobEffectInstance, number>>
        get meat(): boolean
        get nutrition(): number
        get fastFood(): boolean
    }
    type FoodProperties_ = FoodProperties;
    class FacadeItem extends Internal.AEBaseItem implements Internal.IFacadeItem, Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static createFacade(held: Internal.ItemStack_, side: Internal.Direction_): Internal.IFacadePart;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        createFacadeForItemUnchecked(itemStack: Internal.ItemStack_): Internal.ItemStack;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        createPartFromItemStack(is: Internal.ItemStack_, side: Internal.Direction_): Internal.FacadePart;
        setAttackSpeed(attackSpeed: number): void;
        getTextureBlockState(is: Internal.ItemStack_): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getTextureItem(is: Internal.ItemStack_): Internal.ItemStack;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static canPlaceFacade(host: Internal.IPartHost_, facade: Internal.IFacadePart_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        createFromID(id: number): Internal.ItemStack;
        createFacadeForItem(itemStack: Internal.ItemStack_, returnItem: boolean): Internal.ItemStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FacadeItem_ = FacadeItem;
    class CauldronBlock extends Internal.AbstractCauldronBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CauldronBlock_ = CauldronBlock;
    class ChatType$Bound extends Internal.Record {
        constructor($$0: Internal.ChatType_, $$1: net.minecraft.network.chat.Component_, $$2: net.minecraft.network.chat.Component_)
        toNetwork($$0: Internal.RegistryAccess_): Internal.ChatType$BoundNetwork;
        decorateNarration($$0: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        decorate($$0: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        name(): net.minecraft.network.chat.Component;
        targetName(): net.minecraft.network.chat.Component;
        withTargetName($$0: net.minecraft.network.chat.Component_): this;
        chatType(): Internal.ChatType;
    }
    type ChatType$Bound_ = ChatType$Bound;
    interface ToIntFunction <T> {
        abstract applyAsInt(arg0: T): number;
        (arg0: T): number;
    }
    type ToIntFunction_<T> = ToIntFunction<T>;
    class BlendMode {
        constructor()
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number)
        constructor($$0: number, $$1: number, $$2: number)
        isOpaque(): boolean;
        static stringToBlendFactor($$0: string): number;
        static stringToBlendFunc($$0: string): number;
        apply(): void;
        get opaque(): boolean
    }
    type BlendMode_ = BlendMode;
    class LerpingBossEvent extends Internal.BossEvent {
        constructor($$0: Internal.UUID_, $$1: net.minecraft.network.chat.Component_, $$2: number, $$3: Internal.BossEvent$BossBarColor_, $$4: Internal.BossEvent$BossBarOverlay_, $$5: boolean, $$6: boolean, $$7: boolean)
    }
    type LerpingBossEvent_ = LerpingBossEvent;
    class LockCraftingMode extends Internal.Enum<Internal.LockCraftingMode> {
        static values(): Internal.LockCraftingMode[];
        static valueOf(name: string): Internal.LockCraftingMode;
        static readonly LOCK_WHILE_HIGH: Internal.LockCraftingMode;
        static readonly LOCK_UNTIL_PULSE: Internal.LockCraftingMode;
        static readonly LOCK_UNTIL_RESULT: Internal.LockCraftingMode;
        static readonly NONE: Internal.LockCraftingMode;
        static readonly LOCK_WHILE_LOW: Internal.LockCraftingMode;
    }
    type LockCraftingMode_ = "lock_until_result" | LockCraftingMode | "lock_while_high" | "lock_while_low" | "lock_until_pulse" | "none";
    interface IClumpedOrb {
        clumps$resolve(): boolean;
        abstract clumps$getClumpedMap(): Internal.Map<number, number>;
        abstract clumps$setClumpedMap(arg0: Internal.Map_<number, number>): void;
    }
    type IClumpedOrb_ = IClumpedOrb;
    class LakeFeature$Configuration extends Internal.Record implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockStateProvider_, $$1: Internal.BlockStateProvider_)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        barrier(): Internal.BlockStateProvider;
        fluid(): Internal.BlockStateProvider;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.LakeFeature$Configuration>;
    }
    type LakeFeature$Configuration_ = LakeFeature$Configuration;
    class ConduitBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type ConduitBlock_ = ConduitBlock;
    abstract class MapBlockMarker <D extends Internal.CustomMapDecoration> {
        getFlags(): number;
        setPersistent(persistent: boolean): void;
        getName(): net.minecraft.network.chat.Component;
        setPos(pos: BlockPos_): void;
        setRotation(rot: number): void;
        getRotation(): number;
        hasFlag(flag: number): boolean;
        getTypeId(): string;
        shouldRefresh(): boolean;
        getPos(): BlockPos;
        createDecorationFromMarker(data: Internal.MapItemSavedData_): D;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        saveToNBT(compound: Internal.CompoundTag_): Internal.CompoundTag;
        setName(name: net.minecraft.network.chat.Component_): void;
        loadFromNBT(compound: Internal.CompoundTag_): void;
        getMarkerId(): string;
        getType(): Internal.MapDecorationType<D, any>;
        saveToNBT(): Internal.CompoundTag;
        shouldSave(): boolean;
        get flags(): number
        set persistent(persistent: boolean)
        get name(): net.minecraft.network.chat.Component
        set pos(pos: BlockPos_)
        set rotation(rot: number)
        get rotation(): number
        get typeId(): string
        get pos(): BlockPos
        set name(name: net.minecraft.network.chat.Component_)
        get markerId(): string
        get type(): Internal.MapDecorationType<D, any>
        static readonly HAS_SMALL_TEXTURE_FLAG: 1;
    }
    type MapBlockMarker_<D extends Internal.CustomMapDecoration> = MapBlockMarker<D>;
    class ShapedRecipeSchema$ShapedRecipeJS extends Internal.RecipeJS {
        constructor()
        noShrink(): Internal.RecipeJS;
        getMod(): string;
        noMirror(): Internal.RecipeJS;
        get mod(): string
    }
    type ShapedRecipeSchema$ShapedRecipeJS_ = ShapedRecipeSchema$ShapedRecipeJS;
    class ItemStoneStatue extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemStoneStatue_ = ItemStoneStatue;
    class DamageSources {
        constructor($$0: Internal.RegistryAccess_)
        generic(): DamageSource;
        freeze(): DamageSource;
        onFire(): DamageSource;
        genericKill(): DamageSource;
        source($$0: Internal.ResourceKey_<Internal.DamageType>, $$1: Internal.Entity_, $$2: Internal.Entity_): DamageSource;
        thrown($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        cramming(): DamageSource;
        fireworks($$0: Internal.FireworkRocketEntity_, $$1: Internal.Entity_): DamageSource;
        lightningBolt(): DamageSource;
        magic(): DamageSource;
        fireball($$0: Internal.Fireball_, $$1: Internal.Entity_): DamageSource;
        starve(): DamageSource;
        source($$0: Internal.ResourceKey_<Internal.DamageType>, $$1: Internal.Entity_): DamageSource;
        fallingBlock($$0: Internal.Entity_): DamageSource;
        lava(): DamageSource;
        dragonBreath(): DamageSource;
        sting($$0: Internal.LivingEntity_): DamageSource;
        playerAttack($$0: Internal.Player_): DamageSource;
        inFire(): DamageSource;
        trident($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        wither(): DamageSource;
        indirectMagic($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        dryOut(): DamageSource;
        noAggroMobAttack($$0: Internal.LivingEntity_): DamageSource;
        sonicBoom($$0: Internal.Entity_): DamageSource;
        thorns($$0: Internal.Entity_): DamageSource;
        fallingStalactite($$0: Internal.Entity_): DamageSource;
        anvil($$0: Internal.Entity_): DamageSource;
        arrow($$0: Internal.AbstractArrow_, $$1: Internal.Entity_): DamageSource;
        explosion($$0: Internal.Entity_, $$1: Internal.Entity_): DamageSource;
        source($$0: Internal.ResourceKey_<Internal.DamageType>): DamageSource;
        hotFloor(): DamageSource;
        outOfBorder(): DamageSource;
        mobProjectile($$0: Internal.Entity_, $$1: Internal.LivingEntity_): DamageSource;
        mobAttack($$0: Internal.LivingEntity_): DamageSource;
        explosion($$0: Internal.Explosion_): DamageSource;
        inWall(): DamageSource;
        flyIntoWall(): DamageSource;
        stalagmite(): DamageSource;
        fall(): DamageSource;
        witherSkull($$0: Internal.WitherSkull_, $$1: Internal.Entity_): DamageSource;
        drown(): DamageSource;
        badRespawnPointExplosion($$0: Vec3d_): DamageSource;
        cactus(): DamageSource;
        fellOutOfWorld(): DamageSource;
        sweetBerryBush(): DamageSource;
        readonly damageTypes: Internal.Registry<Internal.DamageType>;
    }
    type DamageSources_ = DamageSources;
    interface ByteBufAllocator {
        abstract compositeDirectBuffer(arg0: number): Internal.CompositeByteBuf;
        abstract directBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        abstract buffer(): Internal.ByteBuf;
        abstract compositeHeapBuffer(arg0: number): Internal.CompositeByteBuf;
        abstract heapBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        abstract compositeBuffer(): Internal.CompositeByteBuf;
        abstract compositeDirectBuffer(): Internal.CompositeByteBuf;
        abstract ioBuffer(): Internal.ByteBuf;
        abstract heapBuffer(): Internal.ByteBuf;
        abstract heapBuffer(arg0: number): Internal.ByteBuf;
        abstract ioBuffer(arg0: number): Internal.ByteBuf;
        abstract compositeBuffer(arg0: number): Internal.CompositeByteBuf;
        abstract directBuffer(): Internal.ByteBuf;
        abstract isDirectBufferPooled(): boolean;
        abstract directBuffer(arg0: number): Internal.ByteBuf;
        abstract calculateNewCapacity(arg0: number, arg1: number): number;
        abstract buffer(arg0: number, arg1: number): Internal.ByteBuf;
        abstract ioBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        abstract compositeHeapBuffer(): Internal.CompositeByteBuf;
        abstract buffer(arg0: number): Internal.ByteBuf;
        get directBufferPooled(): boolean
        readonly DEFAULT: Internal.PooledByteBufAllocator;
    }
    type ByteBufAllocator_ = ByteBufAllocator;
    interface IToolPart extends Internal.IMaterialItem {
        canUseMaterial(mat: Internal.IMaterial_): boolean;
        emi(amount: number): Internal.EmiStack;
        canUseMaterial(material: Internal.MaterialId_): boolean;
        abstract getMaterial(arg0: Internal.ItemStack_): Internal.MaterialVariantId;
        abstract asItem(): Internal.Item;
        withMaterialForDisplay(materialId: Internal.MaterialVariantId_): Internal.ItemStack;
        emi(): Internal.EmiStack;
        abstract getStatType(): Internal.MaterialStatsId;
        withMaterial(stack: Internal.ItemStack_, material: Internal.MaterialVariantId_): Internal.ItemStack;
        withMaterial(material: Internal.MaterialVariantId_): Internal.ItemStack;
        getMaterialFromStack(stack: Internal.ItemStack_): Internal.MaterialVariantId;
        get statType(): Internal.MaterialStatsId
    }
    type IToolPart_ = IToolPart;
    class LazySpawnEggItem extends Internal.SpawnEggItem {
        constructor(type: Internal.Supplier_<Internal.EntityType<Internal.Mob>>, backgroundColor: number, highlightColor: number, props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static getEggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static fromEntityType(type: Internal.EntityType_<any>): Internal.SpawnEggItem;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get eggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type LazySpawnEggItem_ = LazySpawnEggItem;
    interface RecipeBuilder {
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>, $$1: string): void;
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>): void;
        getDefaultRecipeId($$0: Internal.ItemLike_): ResourceLocation;
        abstract save(arg0: Internal.Consumer_<Internal.FinishedRecipe>, arg1: ResourceLocation_): void;
        abstract unlockedBy(arg0: string, arg1: Internal.CriterionTriggerInstance_): this;
        abstract getResult(): Internal.Item;
        abstract group(arg0: string): this;
        get result(): Internal.Item
        readonly ROOT_RECIPE_ADVANCEMENT: ResourceLocation;
    }
    type RecipeBuilder_ = RecipeBuilder;
    class Villager extends Internal.AbstractVillager implements Internal.VillagerDataHolder, Internal.AccessorVillager, Internal.ReputationEventHandler, Internal.VillagerEntityAccessor {
        constructor($$0: Internal.EntityType_<Internal.Villager>, $$1: Internal.Level_)
        constructor($$0: Internal.EntityType_<Internal.Villager>, $$1: Internal.Level_, $$2: Internal.VillagerType_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        restock(): void;
        getVillagerData(): Internal.VillagerData;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getGossips(): Internal.GossipContainer;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        method_5992($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        isTouchingUpsideDownFluid(): boolean;
        getPlayerReputation($$0: Internal.Player_): number;
        method_19181(): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        wantsMoreFood(): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        static fabric_setGatherableItems(items: Internal.Set_<Internal.Item>): void;
        getBrain(): Internal.Brain<Internal.Villager>;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        getVariant(): Internal.VillagerType;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        static "fabric_setItemFoodValues$fabric-content-registries-v0_$md$fca01f$0"(arg0: Internal.Map_<any, any>): void;
        setVariant($$0: Internal.VillagerType_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        hex$tellWitnessesThatIWasMurdered(arg0: Internal.Entity_): void;
        attack(hp: number): void;
        shouldRestock(): boolean;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getVariant(): any;
        static fabric_getGatherableItems(): Internal.Set<Internal.Item>;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        wantsToSpawnGolem($$0: number): boolean;
        isChasing(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        static pickUpItem($$0: Internal.Mob_, $$1: Internal.InventoryCarrier_, $$2: Internal.ItemEntity_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        updateSpecialPrices($$0: Internal.Player_): void;
        isWaterCreature(): boolean;
        spawnGolemIfNeeded($$0: Internal.ServerLevel_, $$1: number, $$2: number): void;
        playWorkSound(): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        static fabric_setItemFoodValues(items: Internal.Map_<Internal.Item, number>): void;
        assignProfessionWhenSpawned(): boolean;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        releasePoi($$0: Internal.MemoryModuleType_<Internal.GlobalPos>): void;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        gossip($$0: Internal.ServerLevel_, $$1: Internal.Villager_, $$2: number): void;
        readInventoryFromTag($$0: Internal.CompoundTag_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        writeInventoryToTag($$0: Internal.CompoundTag_): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setGossips($$0: Internal.Tag_): void;
        hasExcessFood(): boolean;
        refreshBrain($$0: Internal.ServerLevel_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        isDynamicLightEnabled(): boolean;
        hasFarmSeeds(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setChasing($$0: boolean): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        openTradingScreen($$0: Internal.Player_, $$1: net.minecraft.network.chat.Component_, $$2: number): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setOffers($$0: Internal.MerchantOffers_): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setVillagerData($$0: Internal.VillagerData_): void;
        eatAndDigestFood(): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setVillagerXp($$0: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        onReputationEventFrom($$0: Internal.ReputationEventType_, $$1: Internal.Entity_): void;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        static "fabric_setGatherableItems$fabric-content-registries-v0_$md$fca01f$1"(arg0: Internal.Set_<any>): void;
        getHeadArmorItem(): Internal.ItemStack;
        static "fabric_getGatherableItems$fabric-content-registries-v0_$md$fca01f$2"(): Internal.Set<any>;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        hex$releaseAllPois(): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        handler$dck000$hexcasting$onThunderHit(serverLevel: Internal.ServerLevel_, lightningBolt: Internal.LightningBolt_, ci: Internal.CallbackInfo_, newWitch: Internal.Witch_): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        get villagerData(): Internal.VillagerData
        get gossips(): Internal.GossipContainer
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get brain(): Internal.Brain<Internal.Villager>
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get variant(): Internal.VillagerType
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        set variant($$0: Internal.VillagerType_)
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get chasing(): boolean
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        set gossips($$0: Internal.Tag_)
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set chasing($$0: boolean)
        set totalMovementSpeedMultiplier(speed: number)
        set offers($$0: Internal.MerchantOffers_)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set villagerData($$0: Internal.VillagerData_)
        set motionX(x: number)
        set villagerXp($$0: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
        static FOOD_POINTS: {[key: Internal.Item]: 4, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 1};
        static readonly SPEED_MODIFIER: 0.5;
        static readonly BREEDING_FOOD_THRESHOLD: 12;
        static MEMORY_TYPES: [Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>];
        static WANTED_ITEMS: Internal.Set<Internal.Item>;
        static readonly POI_MEMORIES: {[key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any};
    }
    type Villager_ = Villager;
    interface Float2IntFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToIntFunction {
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Float2ShortFunction;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2IntFunction;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2IntFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Float2ByteFunction;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2IntFunction;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Float2LongFunction;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Float2FloatFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Float2ObjectFunction<T>;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Float2CharFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2IntFunction;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Float2DoubleFunction;
        apply(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2IntFunction<T>;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2IntFunction<T>;
        size(): number;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2IntFunction;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2IntFunction;
        clear(): void;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Float2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        abstract get(arg0: number): number;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type Float2IntFunction_ = Float2IntFunction;
    class Window$Type extends Internal.Enum<Internal.Window$Type> {
        static values(): Internal.Window$Type[];
        static valueOf(arg0: string): Internal.Window$Type;
        static readonly NORMAL: Internal.Window$Type;
        static readonly UTILITY: Internal.Window$Type;
        static readonly POPUP: Internal.Window$Type;
    }
    type Window$Type_ = "normal" | Window$Type | "popup" | "utility";
    class ToolDefinition {
        validate(data: Internal.ToolDefinitionData_): void;
        setData(data: Internal.ToolDefinitionData_): void;
        static builder(item: io.github.fabricators_of_create.porting_lib.util.RegistryObject_<Internal.ItemLike>): Internal.ToolDefinition$Builder;
        isMultipart(): boolean;
        getStatProvider(): Internal.IToolStatProvider;
        getData(): Internal.ToolDefinitionData;
        getId(): ResourceLocation;
        static builder(id: ResourceLocation_): Internal.ToolDefinition$Builder;
        getRepairParts(): number[];
        buildStats(materials: Internal.MaterialNBT_): Internal.StatsNBT;
        getDefaultMaxTier(): number;
        getMaxRepairWeight(): number;
        isDataLoaded(): boolean;
        static builder(item: Internal.ItemObject_<Internal.ItemLike>): Internal.ToolDefinition$Builder;
        set data(data: Internal.ToolDefinitionData_)
        get multipart(): boolean
        get statProvider(): Internal.IToolStatProvider
        get data(): Internal.ToolDefinitionData
        get id(): ResourceLocation
        get repairParts(): number[]
        get defaultMaxTier(): number
        get maxRepairWeight(): number
        get dataLoaded(): boolean
        static readonly EMPTY: Internal.ToolDefinition;
    }
    type ToolDefinition_ = ToolDefinition;
    interface Animatable <T extends Internal.Animatable<T>> {
        abstract interpolate(arg0: T, arg1: number): T;
        (arg0: T, arg1: number): T;
    }
    type Animatable_<T extends Internal.Animatable<T>> = Animatable<T>;
    interface IModifierRecipe {
        getSlotType(): Internal.SlotType;
        abstract getModifier(): Internal.Modifier;
        get slotType(): Internal.SlotType
        get modifier(): Internal.Modifier
        (): Internal.Modifier_;
    }
    type IModifierRecipe_ = IModifierRecipe;
    class AnimalNet extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AnimalNet_ = AnimalNet;
    class CandleCakeBlock extends Internal.AbstractCandleBlock {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static byCandle($$0: Internal.Block_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static canLight($$0: Internal.BlockState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly LIT: Internal.BooleanProperty;
    }
    type CandleCakeBlock_ = CandleCakeBlock;
    interface DSL$TypeReference {
        "in"(arg0: Internal.Schema_): Internal.TypeTemplate;
        abstract typeName(): string;
        (): string;
    }
    type DSL$TypeReference_ = DSL$TypeReference;
    interface SleepingBlockEntity {
        startSleeping(): boolean;
        abstract getSleepingTicker(): Internal.TickingBlockEntity;
        isSleeping(): boolean;
        wakeUpNow(): void;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        abstract setTickWrapper(arg0: Internal.WrappedBlockEntityTickInvokerAccessor_): void;
        abstract setSleepingTicker(arg0: Internal.TickingBlockEntity_): void;
        abstract getTickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor;
        sleepOnlyCurrentTick(): void;
        get sleepingTicker(): Internal.TickingBlockEntity
        get sleeping(): boolean
        set ticker(delegate: Internal.TickingBlockEntity_)
        set tickWrapper(arg0: Internal.WrappedBlockEntityTickInvokerAccessor_)
        set sleepingTicker(arg0: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor
        readonly SLEEPING_BLOCK_ENTITY_TICKER: Internal.TickingBlockEntity;
    }
    type SleepingBlockEntity_ = SleepingBlockEntity;
    class NetworkedTerminal extends Internal.Terminal {
        constructor(width: number, height: number, colour: boolean)
        constructor(width: number, height: number, colour: boolean, changedCallback: Internal.Runnable_)
        readFromNBT(nbt: Internal.CompoundTag_): void;
        writeToNBT(nbt: Internal.CompoundTag_): Internal.CompoundTag;
    }
    type NetworkedTerminal_ = NetworkedTerminal;
    interface HexBaubleItem {
        abstract getHexBaubleAttrs(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        (arg0: Internal.ItemStack): Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>;
    }
    type HexBaubleItem_ = HexBaubleItem;
    class AstralSorceryCrystalAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(itemStack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type AstralSorceryCrystalAttribute$Type_ = AstralSorceryCrystalAttribute$Type;
}
declare namespace net.p3pp3rf1y.sophisticatedcore.inventory {
    class ItemStackKey {
        static getHashCode(resource: Internal.ItemVariant_): number;
        getStack(): Internal.ItemStack;
        static canItemStacksStack(a: Internal.ItemStack_, b: Internal.ItemStack_): boolean;
        stack(): Internal.ItemStack;
        matches(stack: Internal.ItemStack_): boolean;
        static clearCacheOnTickEnd(): void;
        hashCodeNotEquals(otherStack: Internal.ItemStack_): boolean;
        static getHashCode(stack: Internal.ItemStack_): number;
        matches(resource: Internal.ItemVariant_): boolean;
        static of(stack: Internal.ItemStack_): net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
        get stack(): Internal.ItemStack
    }
    type ItemStackKey_ = ItemStackKey;
}
declare namespace io.github.fabricators_of_create.porting_lib.entity.mixin.common {
    interface BlockableEventLoopAccessor {
        abstract callSubmitAsync(arg0: Internal.Runnable_): Internal.CompletableFuture<void>;
        (arg0: Internal.Runnable): Internal.CompletableFuture_<void>;
    }
    type BlockableEventLoopAccessor_ = BlockableEventLoopAccessor;
    interface EntityAccessor {
        abstract callGetEyeHeight(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        (arg0: Internal.Pose, arg1: Internal.EntityDimensions): number;
    }
    type EntityAccessor_ = EntityAccessor;
}
declare namespace com.mojang.blaze3d.audio {
    class Channel {
        destroy(): void;
        unpause(): void;
        setSelfPosition($$0: Vec3d_): void;
        disableAttenuation(): void;
        attachBufferStream($$0: Internal.AudioStream_): void;
        updateStream(): void;
        playing(): boolean;
        attachStaticBuffer($$0: Internal.SoundBuffer_): void;
        play(): void;
        setLooping($$0: boolean): void;
        linearAttenuation($$0: number): void;
        setRelative($$0: boolean): void;
        setPitch($$0: number): void;
        stop(): void;
        pause(): void;
        setVolume($$0: number): void;
        pumpBuffers($$0: number): void;
        stopped(): boolean;
        set selfPosition($$0: Vec3d_)
        set looping($$0: boolean)
        set relative($$0: boolean)
        set pitch($$0: number)
        set volume($$0: number)
        static readonly BUFFER_DURATION_SECONDS: 1;
    }
    type Channel_ = Channel;
}
declare namespace dev.emi.trinkets.mixin.accessor {
    interface LivingEntityAccessor {
        abstract invokePlayEquipmentBreakEffects(arg0: Internal.ItemStack_): void;
        (arg0: Internal.ItemStack): void;
    }
    type LivingEntityAccessor_ = LivingEntityAccessor;
}
declare namespace it.unimi.dsi.fastutil.doubles {
    interface DoublePredicate extends Internal.DoublePredicate, Internal.Predicate<number> {
        /**
         * @deprecated
        */
        or(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        or(arg0: Internal.DoublePredicate_): this;
        /**
         * @deprecated
        */
        test(arg0: any): boolean;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        abstract test(arg0: number): boolean;
        /**
         * @deprecated
        */
        and(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        and(arg0: Internal.DoublePredicate_): Internal.DoublePredicate;
        or(arg0: it.unimi.dsi.fastutil.doubles.DoublePredicate_): this;
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        negate(): Internal.DoublePredicate;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        and(arg0: it.unimi.dsi.fastutil.doubles.DoublePredicate_): this;
        (arg0: number): boolean;
    }
    type DoublePredicate_ = DoublePredicate;
}
